# 로그레벨(Logging Level)

로그와 관련된 부분은 비즈니스 로직에는 직접적인 연관이 없는 개발자의 자율적인 영역이지만 더 좋은 시스템을 위해 고민하면 좋다. 로그와 로그레벨에 대하여 알아본다.

<br/>

## 로그(Log)

로그(Log)란 모든 상황에서 발생하는 행위와 이벤트 정보 등을 시간에 따라 남긴 데이터이다. 이를 통해 프로그램에서 발생하는 **문제점을 추적** 하거나 **동작 상황을 모니터링**할 수 있다.

로그파일(Log file)은 이러한 수천 수백만개의 기록이다. 로그는 다음과 같은 형태를 띈다.  
`GET /login-2021-12-14-17:00:00-Browser:Chrome-OS:Windows 10`

로그를 남기는 방법은 크게 두 가지로 생각할 수 있다.

1. 직접 출력하기  
   `stdout`, `stderror` (c 기준) 방식으로 출력하는 것이다.

   ```python
   print("Hello, World!") #python
   console.log("Hello, World!"); #js
   System.out.println("Hello, World!"); #c
   ```

2. Logging Library 사용하기  
   로깅 라이브러리(log4j, slf4j, logback, nlog 등)을 이용하는 방법으로, 실제로 많이 사용되고 있다. 이러한 로그 기록 라이브러리, 프레임워크 들은 로그를 포맷팅하고 필터링하고 파일로 기록하는 일을 한다.

   로그에 대한 기본적인 설명과, Log4J로 인해 일어났던 최악의 전세계적 보안사태에 관한 영상. _(추천)_  
   [노마드 코더 | 애플도 당했다! 최악의 보안사태 "Log4J" 설명해드림. 10분컷.](https://www.youtube.com/watch?v=kwS3twdVsko)

   > 2021-12-10일에 발견된 CVE(Common Vulnerability Exposure) `Log4Shell`은 0 Day Vulnerability로 CVSS Score 10/10을 기록함.

<br/>

## 로그레벨

로그레벨은 로그(Log) 메세지의 중요도를 나타내는 단계이다. 로깅 시스템에서 사용되며, 로그레벨에 따라 로그 메세지 기록 여부를 결정한다. 로그레벨은 다음과 같은 우선순위를 갖는다.(log4j 기준)

| Log Level | Description                                                                                                             |
| --------- | ----------------------------------------------------------------------------------------------------------------------- |
| ALL       | The ALL has the lowest possible rank and is intended to turn on all logging                                             |
| **DEBUG** | The DEBUG Level designates fine-grained informational events that are most useful to debug an application               |
| **ERROR** | The ERROR level designates error events that might still allow the application to continue running                      |
| **FATAL** | The FATAL level designates very severe error events that will presumably lead the application to abort                  |
| **INFO**  | The INFO level designates informational messages that highlight the progress of the application at coarse-grained level |
| OFF       | The OFF has the highest possible rank and is intended to turn off logging                                               |
| TRACE     | The TRACE Level designates finer-grained informational events than the DEBUG                                            |
| TRACE_INT | TRACE level integer value                                                                                               |
| **WARN**  | The WARN level designates potentially harmful situations                                                                |

<br/>

다음과 같은 중요도 순위를 갖는다.

`ALL` < `TRACE` < `DEBUG` < `INFO` < `WARN` < `ERROR` < `FATAL` < `OFF`

<br/>

### Logging Level Example

아래는 지정한 로그레벨에 대하여 기록된 로그의 예시이다. 지정한 로그레벨 이상의 로그 메세지만 기록된다.

```java
import org.apache.log4j.*;

public class LogClass {
   private static org.apache.log4j.Logger log = Logger.getLogger(LogClass.class);

   public static void main(String[] args) {
      log.setLevel(Level.WARN); // 로그레벨 지정

      log.trace("Trace Message!");
      log.debug("Debug Message!");
      log.info("Info Message!");
      log.warn("Warn Message!");
      log.error("Error Message!");
      log.fatal("Fatal Message!");
   }
}
```

```shell
# WARN 보다 높은 레벨의 로그가 기록된다.
Warn Message!
Error Message!
Fatal Message!
```

---

## Reference

▶️ https://www.youtube.com/watch?v=kwS3twdVskowhat-should-i-log-with-an-intention-method-and-level/  
📄 https://blog.lulab.net/programmer/what-should-i-log-with-an-intention-method-and-level/  
📄 https://www.tutorialspoint.com/log4j/log4j_logging_levels.htm  
📄 https://pig-programming.tistory.com/51
